library(ggplot2)
library(kedd)
library(readr)

# Bandwidth functions
bandwidth <- function(sample) {
  n <- length(sample)
  sd_y <- sd(sample)
  iqr_y <- IQR(sample)
  0.9 * min(sd_y, iqr_y / 1.34) * n^(-0.2)
}

# Kernels
normal_kernel <- function(x) (1 / sqrt(2 * pi)) * exp(-0.5 * x^2)
biweight_kernel <- function(t) ifelse(abs(t) <= 1, (15/16) * (1 - t^2)^2, 0)

# KDE functions
kde_generic <- function(x, sample, h, kernel_func) {
  m <- length(sample)
  sapply(x, function(xx) sum(kernel_func((xx - sample) / h)) / (m * h))
}

# KDE ROC function
ROC_kde <- function(X, Y, h_x, h_y, kernel_func) {
  x_vals <- seq(min(c(X, Y)) - 2 * h_x, max(c(X, Y)) + 2 * h_y, length.out = 1000)
  f_hat <- kde_generic(x_vals, X, h_x, kernel_func)
  g_hat <- kde_generic(x_vals, Y, h_y, kernel_func)
  dx <- x_vals[2] - x_vals[1]
  FPR <- 1 - cumsum(f_hat) * dx
  TPR <- 1 - cumsum(g_hat) * dx
  data.frame(FPR = FPR, TPR = TPR)
}
