% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UDF.R
\name{AUC}
\alias{AUC}
\title{Calculates AUC, confidence intervals, and generates a ROC plot.}
\usage{
AUC(
  data,
  method,
  ci = TRUE,
  ci_method = "delong",
  siglevel = 0.05,
  boot_iter = 1000
)
}
\arguments{
\item{data}{A data frame containing at least two columns:
\describe{
  \item{biomarker}{Numeric values representing the diagnostic marker.}
  \item{status}{Character or factor with levels `"0"` (controls) and `"1"` (cases).}
}}

\item{method}{A character string specifying the ROC/AUC modeling approach.
Supported options include:
\itemize{
  \item `"empirical"` – empirical ROC
  \item `"order"` – ROC curve under stochastic order constraints
  \item `"norm_silver"` – kernel ROC with normal kernel and Silverman bandwidth
  \item `"norm_ucv"` – kernel ROC with normal kernel and UCV bandwidth
  \item `"bi_silver"` – kernel ROC with biweight kernel and Silverman bandwidth
  \item `"bi_ucv"` – kernel ROC with biweight kernel and UCV bandwidth
  \item `"binormal"` – classical binormal ROC model
  \item `"biweibull"` – parametric bi-Weibull ROC
  \item `"bigamma"` – parametric ROC assuming gamma distributions
  \item `"lehmann"` – ROC under the Lehmann alternative
  \item `"bayesbiweibull"` – Bayesian bi-Weibull ROC (MCMC-based)
  \item `"BB"` – Bayesian bootstrap ROC
  \item `"dpm"` – Dirichlet process mixture ROC
}}

\item{ci}{Logical; if `TRUE` (default), computes confidence intervals for the AUC
(or credible intervals for Bayesian methods).}

\item{ci_method}{Character string specifying the type of interval estimation.
Not all CI methods are compatible with every model:
\itemize{
  \item `"delong"` – DeLong’s variance-based normal approximation
  \item `"bootstrap"` – nonparametric bootstrap interval
  \item `"hm"` – Hanley–McNeil variance-based interval
  \item `"mle"` – likelihood-based interval
  \item `"all"` – computes all applicable interval types for the selected method
}}

\item{siglevel}{Numeric; significance level \eqn{\alpha} for the confidence interval.
The corresponding confidence level is \eqn{1 - \alpha}.}

\item{boot_iter}{Integer; number of bootstrap resamples (used when
`ci_method = "bootstrap"` or `"all"`). Larger values give more stable intervals
but increase computation time.}
}
\value{
A list with the following elements:
  \describe{
    \item{summary}{Printed output of the AUC and confidence intervals.}
    \item{plot}{A `ggplot` object visualizing the ROC curve.}
  }
  The exact structure may vary depending on the chosen model.
}
\description{
Calculates AUC, confidence intervals, and generates a ROC plot.
}
\examples{
# Import well formated dataset
data(DMDmodified) 
# Calculate AUC summary and ROC plot
auc <- AUC(
  data=DMDmodified,
  method = "empirical",
  ci        = TRUE
)
# Get the AUC summary
cat(auc$summary)
# Get the ROC plot
auc$plot
}
