# Detection of Muscular Dystrophy Carriers

This dataset contains measurements from 209 female subjects evaluated
for carrier status of Ducheme Muscular Dystrophy (DMD). The dataset is a
classic example used in diagnostic test evaluation and appears in
Andrews and Herzberg (2012). It includes basic demographic variables and
four serum biomarkers that may be elevated in carriers even when outward
symptoms are absent.

## Usage

``` r
dystrophy
```

## Format

A data frame with 209 rows and 11 variables:

- OBS:

  Observation number.

- HospID:

  Hospital ID number.

- AGE:

  Age in years.

- M:

  Month of examination.

- Y:

  Year of examination.

- CK:

  Serum creatine kinase (primary biomarker).

- H:

  Serum hemopexin.

- PK:

  Serum pyruvate kinase.

- LD:

  Serum lactate dehydrogenase.

- Class:

  Factor with levels `"carrier"` (diseased/positive) and `"normal"`
  (non-carrier).

## Source

Adapted from the dataset in Andrews and Herzberg (2012)

## References

Andrews, D. F., & Herzberg, A. M. (2012). Data: a collection of problems
from many fields for the student and research worker. Springer Science &
Business Media.
