% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dystrophyData.R
\docType{data}
\name{dystrophy}
\alias{dystrophy}
\title{Detection of Muscular Dystrophy Carriers}
\format{
A data frame with 209 rows and 11 variables:
\describe{
  \item{OBS}{Observation number.}
  \item{HospID}{Hospital ID number.}
  \item{AGE}{Age in years.}
  \item{M}{Month of examination.}
  \item{Y}{Year of examination.}
  \item{CK}{Serum creatine kinase (primary biomarker).}
  \item{H}{Serum hemopexin.}
  \item{PK}{Serum pyruvate kinase.}
  \item{LD}{Serum lactate dehydrogenase.}
  \item{Class}{Factor with levels \code{"carrier"} (diseased/positive)
    and \code{"normal"} (non-carrier).}
}
}
\source{
Adapted from the dataset in Andrews and Herzberg (2012)
}
\usage{
dystrophy
}
\description{
This dataset contains measurements from 209 female subjects evaluated for
carrier status of Ducheme Muscular Dystrophy (DMD). The dataset is a classic
example used in diagnostic test evaluation and appears in
Andrews and Herzberg (2012). It includes basic demographic
variables and four serum biomarkers that may be elevated in carriers even
when outward symptoms are absent.
}
\references{
Andrews, D. F., & Herzberg, A. M. (2012). Data: a collection of problems from many fields for the student and research worker. Springer Science & Business Media.
}
\keyword{datasets}
